/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import com.google.common.base.Predicate;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.tileentity.TileEntityClaymore;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockClaymore
extends BlockContainer
implements IExplosive {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool DEACTIVATED = PropertyBool.func_177716_a((String)"deactivated");

    public BlockClaymore(Material material) {
        super(material);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World world, BlockPos pos) {
        return null;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c().isSideSolid(world.func_180495_p(pos.func_177977_b()), (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() == SCContent.wireCutters) {
                world.func_175656_a(pos, SCContent.claymore.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
                return true;
            }
            if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() == Items.field_151033_d) {
                world.func_175656_a(pos, SCContent.claymore.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
                return true;
            }
        }
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!(player.field_71075_bZ.field_75098_d || world.field_72995_K || ((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)DEACTIVATED)).booleanValue())) {
            BlockUtils.destroyBlock(world, pos, false);
            world.func_72876_a((Entity)null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 3.5f, true);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        if (!world.field_72995_K && BlockUtils.hasBlockProperty(world, pos, DEACTIVATED) && !((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
            if (pos.equals((Object)new BlockPos(explosion.getPosition()))) {
                return;
            }
            BlockUtils.destroyBlock(world, pos, false);
            world.func_72876_a((Entity)null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 3.5f, true);
        }
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public void activateMine(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            BlockUtils.setBlockProperty(world, pos, DEACTIVATED, false);
        }
    }

    @Override
    public void defuseMine(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            BlockUtils.setBlockProperty(world, pos, DEACTIVATED, true);
        }
    }

    @Override
    public void explode(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            BlockUtils.destroyBlock(world, pos, false);
            world.func_72876_a((Entity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 3.5f, true);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (source.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.NORTH) {
            return new AxisAlignedBB((double)0.225f, 0.0, (double)0.175f, (double)0.775f, (double)0.325f, (double)0.45f);
        }
        if (source.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            return new AxisAlignedBB((double)0.225f, 0.0, (double)0.55f, (double)0.775f, (double)0.325f, (double)0.825f);
        }
        if (source.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.EAST) {
            return new AxisAlignedBB((double)0.55f, 0.0, (double)0.225f, (double)0.825f, (double)0.335f, (double)0.775f);
        }
        return new AxisAlignedBB((double)0.175f, 0.0, (double)0.225f, (double)0.45f, (double)0.335f, (double)0.775f);
    }

    public IBlockState func_176203_a(int meta) {
        if (meta <= 5) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(EnumFacing.values()[meta].func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.NORTH : EnumFacing.values()[meta])).func_177226_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(true));
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.values()[meta - 6]).func_177226_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(false));
    }

    public int func_176201_c(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
            return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() + 6;
        }
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, DEACTIVATED});
    }

    @Override
    public boolean isActive(World world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)DEACTIVATED) == false;
    }

    @Override
    public boolean isDefusable() {
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityClaymore();
    }
}

